﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Layout;
using DXLib.UI.Control;

namespace iStatVball3;

/*
 * View template for SfTreeView for leaf level help topics.
 */
public class HelpTemplateTopic : DXGridLayout
{
	/* Methods */
	public HelpTemplateTopic()
	{
		BackgroundColor = DXColors.Transparent;

		Padding = new Thickness( 5, 0 );
		RowSpacing = 0;
		ColumnSpacing = 5;

		const double iconSize = 24;

		// 3 columns
		AddFixedColumn( iconSize );		// 0: icon
		AddStarColumn();				// 1: name
		AddAutoColumn();				// 2: duration

		// Un-viewed status
		DXIcon unviewedIcon = new()
		{
			Size = iconSize,
			Margin = 0,

			Resource = "play_outline",
			Color = DXColors.Positive,

			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Center
		};

		Add( unviewedIcon, 0, 0 );

		// Viewed status (covers unviewed)
		DXIcon viewedIcon = new()
		{
			IsVisible = false,

			Size = iconSize,
			Margin = 0,

			Resource = "play_outline",
			Color = DXColors.Light1,

			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Center
		};

		viewedIcon.SetBinding( IsVisibleProperty, new Binding( "Content.Viewed" ) );

		Add( viewedIcon, 0, 0 );

		// Topic (video) name
		DXLabel nameLbl = new()
		{
			Font = DXFonts.Roboto,
			FontSize = 15,
			TextColor = DXColors.Dark1,

			VerticalTextAlignment = TextAlignment.Center,
			LineBreakMode = LineBreakMode.WordWrap,

			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Center
		};

		nameLbl.SetBinding( Label.TextProperty, new Binding( "Content.Name" ) );

		Add( nameLbl, 1, 0 );

		// Duration
		DXLabel durationLbl = new()
		{
			Font = DXFonts.Roboto,
			FontSize = 12,
			TextColor = DXColors.Dark4,

			Margin = 0,
			VerticalTextAlignment = TextAlignment.Center,

			Horizontal = LayoutOptions.End,
			Vertical = LayoutOptions.Center
		};

		durationLbl.SetBinding( Label.TextProperty, new Binding( "Content.Duration" ) );

		Add( durationLbl, 2, 0 );
	}
}

//
