﻿/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

using FFImageLoading.Maui;

using DXLib.UI;
using DXLib.UI.Layout;

using DXLib.UI.Control;
using DXLib.UI.Control.Tree;
using DXLib.UI.Control.Image;

namespace iStatVball3;

/*
 * View template for SfTreeView for categories beneath the root level.
 */
public class HelpTemplateCategory : DXGridLayout
{
	/* Methods */
	public HelpTemplateCategory()
	{
		BackgroundColor = DXColors.Light4;
		
		Padding = new Thickness( 10, 0, 0, 0 );
		ColumnSpacing = 5;

		const double iconSize = DXTree.ExpanderSize;
		
		// Custom expander icon
		DXImage icon = new()
		{
			Vertical = LayoutOptions.Fill,
			Horizontal = LayoutOptions.Fill
		};
		
		icon.SetSize( iconSize, iconSize );

		Binding source = new( "IsExpanded" ) { Converter = new DXTreeConverter() };
		Binding visibility = new( "HasChildNodes" ) { Converter = new DXTreeVisibilityConverter() };

		icon.SetBinding( CachedImage.SourceProperty, source );
		icon.SetBinding( IsVisibleProperty, visibility );
		
		// Category name
		DXLabel label = new()
		{
			TextColor = DXColors.Dark1,
			Font = DXFonts.Roboto,
			FontSize = 17,

			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Center
		};

		label.SetBinding( Label.TextProperty, new Binding( "Content.Name" ) );

		// 1 row, 2 columns
		AddFixedColumn( iconSize );		// 0: icon
		AddStarColumn();				// 1: label
		
		Add( icon, 0, 0 );
		Add( label, 1, 0 );
	}
}

//
