﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using Syncfusion.TreeView.Engine;

namespace iStatVball3;

/*
 * DataTemplateSelector for SfTreeView returning custom templates for each level of the hierarchical help tree.
 */
public class HelpTreeSelector : DataTemplateSelector
{
	/* Fields */
	private readonly DataTemplate root;
    private readonly DataTemplate category;
    private readonly DataTemplate topic;

    /* Methods */
    public HelpTreeSelector()
    {
        root = new DataTemplate( typeof( HelpTemplate ) );
        category = new DataTemplate( typeof( HelpTemplateCategory ) );
        topic = new DataTemplate( typeof( HelpTemplateTopic ) );
    }

	// Returns template based on tree level
    protected override DataTemplate OnSelectTemplate( object item, BindableObject container )
    {
		if ( item is not TreeViewNode node )
        {
			return null;
        }

		// Root
		if ( node.Level == 0 )
        {
			return root;
        }

		// Subcategory or leaf topic
		return node.HasChildNodes ? category : topic;
    }
}

//
