﻿/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

using System.ComponentModel;
using System.Collections.ObjectModel;

namespace iStatVball3;

/*
 * Provides ItemSource implementation for SfTreeView with hierarchical help category/topic data.
 */
public class HelpTreeData : INotifyPropertyChanged
{
	/* Properties */

	// Reference to parent SfTreeView
	public HelpTree Tree { get; set; }

	// LUT key
	public string Key { get; set; }

	// Status icon
	public bool Viewed { get => viewed; set { viewed = value; RaiseOnPropertyChanged( "Viewed" ); } }

	// Video info
	public string Name { get; set; }
	public string Duration { get; set; }

	// Vimeo IDs
	public string VideoId { get; set; }
	public string VideoSig { get; set; }

	// Hierarchical nodes
	public ObservableCollection<HelpTreeData> SubData { get; set; }

	/* Events */
	public event PropertyChangedEventHandler PropertyChanged;

	/* Fields */
	private bool viewed;

	/* Methods */

	// Fires property changed event when view status modified
	private void RaiseOnPropertyChanged( string name )
	{
		PropertyChanged?.Invoke( this, new PropertyChangedEventArgs( name ) );
	}
}

//
