﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI.Container;
using DXLib.Utils;

namespace iStatVball3;

/*
 * Implements UI for the Help toolbar drawer. The bottom of the drawer displays various help links.
 */
public class HelpDrawer : ToolBarDrawer
{
	/* Methods */
	public HelpDrawer( DXDrawer drawer ) : base( drawer )
	{
		// Main content
		HelpContent content = new( this );

		AddStarRow();
		Add( content, 0, 0 );

		// Help link footer
		HelpFooter footer = [];

		double footerHt = (164 + DXDevice.SafeArea().Bottom);
		
		AddFixedRow( footerHt );
		Add( footer, 0, 1 );
	}
}

//
