﻿/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Container;
using DXLib.Utils;

namespace iStatVball3;

/* 
 * Main content panel for the help drawer, which displays a hierarchical list of help video tutorial topics.
 */ 
public class HelpContent : DXScroll
{
	/* Methods */
	public HelpContent( ToolBarDrawer drawer )
	{
		BackgroundColor = DXColors.Light4;

		Padding = 15;
		Margin = 0;

		Horizontal = LayoutOptions.Fill;
		Vertical = LayoutOptions.Fill;
		
		Orientation = ScrollOrientation.Vertical;
		
		// Help tree
		HelpTree helpTree = new();

		// Force full width on mobile landscape
		AdjustForSafeArea( helpTree );

		// Populate data
		helpTree.Init();

		Content = helpTree;
		
		// Let parent handle close
		drawer.Closed = drawer.Hide;
	}
}

//
