﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI.Container;
using DXLib.Utils;

namespace iStatVball3;

/*
 * Implements UI for the Account toolbar drawer, which displays information on the currently logged-in user as well as
 * T&C and privacy policy links.
 */
public class AccountDrawer : ToolBarDrawer
{
	/* Methods */
	public AccountDrawer( DXDrawer drawer ) : base( drawer )
	{
		// Main content
		AccountContent content = new AccountContent( this );

		AddStarRow();
		Add( content, 0, 0 );

		// T&C/privacy footer
		AccountFooter footer = [];

		double footerHt = (92 + DXDevice.SafeArea().Bottom);
		
		AddFixedRow( footerHt );
		Add( footer, 0, 1 );
	}
}

//
