﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI.Card;

namespace iStatVball3;

/*
 * Layer between DXLib and the object-specific card pages. 
 */ 
public abstract class CardPage( object data ) : DXCardPage( data )
{
	/* Methods */

	// Adds 'Add New' card to card list, must be called from LoadCards
	protected void AddNewCard( string type, double ht )
	{
		// Create card
		DXCardNew card = new()
		{
			Type = type,
			CardHt = ht,
			CardTapped = OnNewCardTapped
		};
		
		card.Init();
		
		// User can configure where card is shown
		Settings settings = Shell.Settings;

		// Start of list
		if ( settings.GeneralAdd == "start" )
		{
			cards.Insert( 0, card );
		}
		// End of list
		else
		{
			cards.Add( card );
		}
	}

	/* Event Callbacks */

	// Must be overridden by concrete classes
	protected abstract void OnNewCardTapped( DXCard card );
}

//
