﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI.Control.Badge;
using DXLib.Utils;

namespace iStatVball3;

/*
 * A large sized card layout used on many card pages throughout the app.
 */
public class CardLarge : CardBase
{
	/* Constants */
	public const double CardHt = 430;
	private const double ImageRatio = 43;

	/* Properties */
	public int Count { get => counter.Count; set => counter.Count = value; }
	public string CountTitle { get => counter.Title; set => counter.Title = DXString.GetPlural( value, Count ); }

	/* Fields */
	private readonly DXCounterBadge counter;

	/* Methods */
	public CardLarge( bool readOnly = false ) : base( readOnly )
	{
		/* Layout */

		// 4 rows
		layout.AddStarRow( ImageRatio );	// Image/icon
		layout.AddStarRow( 24 );			// Labels
		layout.AddStarRow( 20 );			// Count
		layout.AddStarRow( 13 );            // Buttons

		// 3 columns
		layout.AddAutoColumn();		        // Main/count
		layout.AddStarColumn( 3 );			// Record
		layout.AddStarColumn( 1 );			// Lock/link

		/* Controls */

		// Icon/photo
		layout.Add( imageArea, 0, 0, 3, 0 );

		// Labels
		layout.Add( labels, 0, 1, 3, 0 );

		// Counter badge
		counter = new DXCounterBadge
		{
			Margin = 10,
			Vertical = LayoutOptions.Center
		};

		layout.Add( counter, 0, 2 );

		// Record
		layout.Add( recordLbl, 1, 2 );

		// Analyze/Edit buttons
		buttons.Margin = new Thickness( 10, 10 );
		buttons.Vertical = LayoutOptions.End;

		layout.Add( buttons, 0, 3, 2, 0 );

		// Lock
		if ( readOnly || GlobalLock )
		{
			layout.Add( lockBtn, 2, 3 );
		}
	}

	// Card specific link status badge layout
	protected override void SetLinkStatus( Link.StatusType? status )
	{
		base.SetLinkStatus( status );

		// Only layout if necessary
		if ( linkBtn is { IsVisible: true } )
		{
			linkBtn.Size = 30;
			layout.Add( linkBtn, 2, 3 );
		}
	}

	// Required implementation
	public override double GetViewHt()
	{
		return CardHt;
	}
}

//
