﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI.Layout;

using DXLib.UI.Control;
using DXLib.UI.Control.Button;

namespace iStatVball3;

/*
 * Encapsulates the common buttons present on most cards throughout the app. Allows layout independent of parent layout.
 */
public class CardButtons : DXHorizontalLayout
{
	/* Events */
	public Action AnalyzeTapped { get; init; }
	public Action EditTapped { get; init; }

	/* Properties */
	public bool HasAnalyze { set => analyzeBtn.IsVisible = value; }
	public bool HasEdit { set => editBtn.IsVisible = value; }

	public bool IsAnalyzeEnabled { set => analyzeBtn.IsDisabled = !value; }
	public bool IsEditEnabled { set => editBtn.IsDisabled = !value; }

	/* Fields */
	private readonly DXButton analyzeBtn;
	private readonly DXButton editBtn;

	/* Method */
	public CardButtons()
	{
		Padding = 0;
		Margin = 0;
		Spacing = 10;

		Vertical = LayoutOptions.Start;
		
		// Analyze
		analyzeBtn = new DXButton
		{
			IsVisible = false,

			Resource = "card.analyze",
			Type = DXButton.ButtonType.Neutral,

			IsSticky = true,

			ButtonWd = 92,
			ButtonTapped = OnAnalyzeTapped
		};

		analyzeBtn.Init();
		
		Add( analyzeBtn );

		// Edit
		editBtn = new DXButton
		{
			Resource = "card.edit",
			Type = DXButton.ButtonType.Neutral,

			IsSticky = true,

			ButtonTapped = OnEditTapped
		};

		editBtn.Init();
		
		Add( editBtn );
	}

	// Resets button sticky states
	public void Reset()
	{
		analyzeBtn.Reset();
		editBtn.Reset();
	}

	// Determines if specified point within buttons bounds
	public bool IsChildBounds( Point point )
	{
		Rect bounds = new( X, Y, (X + editBtn.Bounds.Right), editBtn.Bounds.Height );

		// Exclude empty layout area outside of buttons
		return bounds.Contains( point );
	}

	/* Event Callbacks */

	// Analyze button tapped, callback registered listener
	private void OnAnalyzeTapped( object sender )
	{
		AnalyzeTapped?.Invoke();
	}

	// Edit button tapped, callback registered listener
	private void OnEditTapped( object sender )
	{
		DXSpinner.Start();

		EditTapped?.Invoke();
	}
}
 
//
