﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Gestures;

namespace iStatVball3;

/*
 * A smaller version of ScoreButton implementing a tappable ScoreCard for use on the court on mobile (RallyFlow only).
 */ 
public class ScoreSmall : DXAbsoluteGestures
{
	/* Events */
	public Action ButtonTapped { get; set; }

	/* Properties */
	public int Score { set => card.Score = value; }
	public Color BarColor { set => card.BarColor = value; }

	public bool IsDisabled { set { IsEnabled = !value; card.IsDisabled = value; } }

	/* Fields */
	private readonly ScoreCard card;

	/* Methods */
	public ScoreSmall()
	{
		// Create underlying card
		card = new ScoreCard
		{
			BarHt = 8,
			ScoreSize = 24,

			CardColor = DXColors.Light4,
			ScoreColor = DXColors.Dark1,
			OutlineColor = DXColors.Dark1,

			CornerRadius = 2,
			HasShadow = true,
			HasOutline = true,

			IsSmall = true,

			AdjustX = 0.5f,
			AdjustY = -0.5f,
		};

		SetFullBounds( card );
		Add( card );

		// Register for events
		Tapped += OnTapped;

		// Defaults
		IsDisabled = false;
	}

	/* Event Callbacks */

	// User tapped anywhere on card
	private void OnTapped( object sender, MR.Gestures.TapEventArgs args )
	{
		ButtonTapped?.Invoke();
	}
}

//
