﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Container;
using DXLib.UI.Control.Image;

using DXLib.Utils;

namespace iStatVball3;

/*
 * Responsible for drawing app logo in scoreboard for all layout configurations.
 */ 
public class ScoreLogo : DXContent
{
	/* Properties */
	public bool Legacy { get; set; }

	/* Fields */
	private readonly DXImage image;

	/* Methods */
	public ScoreLogo()
	{
		BackgroundColor = DXColors.Dark2;
		
		// Underlying image
		image = new DXImage
		{
			DownsampleToViewSize = false,
			Aspect = Aspect.AspectFit,
			
			Horizontal = LayoutOptions.Fill,
			Vertical = LayoutOptions.Fill
		};

		Content = image;
	}

	// Adjusts logo size
	public override void SetSize( double wd, double ht )
	{
		base.SetSize( wd, ht );
		
		image.WidthRequest = wd;
		image.HeightRequest = ht;
	}

	/* Layout */

	// Landscape (4:3)
	protected override void Landscape()
	{
		if ( Legacy )
		{
			SetMargin( 5, 0, 0, 0 );

			image.FromResource( "logo_legacy.png" );
		}
		else
		{
			image.FromResource( "logo_rally.png" );
		}
	}

	// Widescreen Landscape (16:10)
	protected override void WideLandscape()
	{
		Landscape();
	}

	// Portrait (3:4)
	protected override void Portrait()
	{
		if ( Legacy )
		{
			SetPadding( 3, 0, 0, 0 );

			image.FromResource( "logo_legacy.png" );
		}
		else
		{
			Padding = new Thickness( 12, 10 );

			image.FromResource( DXDevice.IsTabletWide ? "logo_rallyc.png" : "logo_rallyb.png" );
		}
	}

	// Widescreen Portrait (10:16)
	protected override void WidePortrait()
	{
		Portrait();
	}

	// Mobile Landscape
	protected override void MobileLandscape()
	{
		image.FromResource( Legacy ? "logo_legacy.png" : "logo_rally.png" );

		Padding = 0;
	}

	// Mobile Portrait
	protected override void MobilePortrait()
	{
		if ( Legacy )
		{
			image.FromResource( "logo_legacy.png" );
			Padding = 0;
		}
		else
		{
			image.FromResource( "logo_rally.png" );
			Padding = new Thickness( 20, 10 );
		}
	}
}

//
