﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Container;

namespace iStatVball3;

/*
 * Slide out drawer used to display a live stat analysis report within the recording interface. The report can show
 * either set or match stats as well as stats for either the primary team or opponent.
 */
public class ReportDrawer : ToolBarDrawer
{
	/* Fields */
	private ReportDrawerView view;

	/* Methods */
	public ReportDrawer( DXDrawer drawer ) : base( drawer )
	{
		BackgroundColor = DXColors.Dark2;

		Padding = 15;
		RowSpacing = 0;
		ColumnSpacing = 0;
	}

	// Post construction initialization
	public async Task Init( Set set )
	{
		// Create underlying control
		view = new ReportDrawerView()
		{
			LargeBars = true,
			TextSize = 14
		};

		await view.Init( set );

		Add( view, 0, 0 );	
	}

	// Loads all stats to be displayed in log
	public async Task Load()
	{
		await view.Load();
	}

	/* Layout */

	// Landscape (4:3)
	protected override void Landscape()
	{
		view.TextSize = 14;
	}

	// Portrait (3:4)
	protected override void Portrait()
	{
		view.TextSize = 14;
	}

	// Widescreen landscape (16:10)
	protected override void WideLandscape()
	{
		view.TextSize = 13;
	}

	// Widescreen portrait (10:16)
	protected override void WidePortrait()
	{
		view.TextSize = 13;
	}

	// Mobile (landscape)
	protected override void MobileLandscape()
	{
		view.TextSize = 14;
	}

	// Mobile (portrait)
	protected override void MobilePortrait()
	{
		view.TextSize = 10;
	}
}

//
