﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Layout;
using DXLib.UI.Control.Button;

using DXLib.Utils;

namespace iStatVball3;

/*
 * A static panel with numeric text used throughout the recording UI drawers. Can be either a circle or rounded rectangle.
 * The panel is NOT tappable.
 */
public class DrawerPanel : DrawerBase
{
	/* Properties */
	public int Number { set => numberBtn.Number = value; }
	public string Text { set => numberBtn.Text = value; }

	public double NumberSize { set => numberBtn.NumberSize = value; }
	public double NumberAdjustY { set => numberBtn.TextAdjustY = value; }
	
	public bool IsCircle { set => numberBtn.IsCircle = value; }

	/* Fields */
	private readonly DXNumberButton numberBtn;

	/* Methods */
	public DrawerPanel( DXAbsoluteLayout layout ) : base( layout )
	{
		bool ios = DXDevice.IsIOS;
		
		// Underlying button
		numberBtn = new DXNumberButton
		{
			NumberColor = DXColors.Light3,
			Color = DXColors.Dark3,
			
			IsCircle = false,
			HasShadow = false,
			
			TextAdjustY = ios ? 0 : -6,
			
			Horizontal = LayoutOptions.Fill,
			Vertical = LayoutOptions.Fill
		};

		numberBtn.Init();
		
		layout.Add( numberBtn );
	}

	// Hides panel
	protected override void SetVisible( bool visible )
	{
		base.SetVisible( visible );

		numberBtn.IsVisible = visible;
	}

	// Visually disables panel
	protected override void SetDisabled( bool disabled )
	{
		base.SetDisabled( disabled );

		numberBtn.IsDisabled = disabled;
	}

	// Removes UI components from parent view
	public override void Remove()
	{
		base.Remove();

		layout.Remove( numberBtn );
	}

	/* Layout */

	// Positions button in parent layout
	public override void Layout( double x, double y, double size )
	{
		base.Layout( x, y, size );

		// Title is optional
		double btnY = y + (string.IsNullOrEmpty( Title ) ? 0 : (TitleHt + Spacing));

		numberBtn.Size = size;
		layout.SetBounds( numberBtn, x, btnY, size, size );
	}
}

//
