﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Layout;
using DXLib.UI.Control.Button;

namespace iStatVball3;

/*
 * An icon button with a text title used throughout the recording UI drawers.
 */
public class DrawerIcon : DrawerBase
{
	/* Events */
	public Action ButtonTapped { set => iconBtn.ButtonTapped = value; }
	public Action ButtonPressed { set => iconBtn.ButtonPressed = value; }

	/* Properties */
	public string Resource { set => iconBtn.Resource = value; }

	public bool IsCircle { get; set; }
	public Color Color { set => iconBtn.ButtonColor = value; }

	// Draw control
	public Rect Bounds => iconBtn.Bounds;
	public View View => iconBtn;

	// State control
	public bool IsSticky { set => iconBtn.IsSticky = value; }

	/* Fields */
	private readonly DXIconButton iconBtn;

	/* Methods */
	public DrawerIcon( DXAbsoluteLayout layout ) : base( layout )
	{
		// Underlying control
		iconBtn = new DXIconButton
		{
			CornerRadius = 4,
			HasShadow = true,
			IsSticky = false,

			IconColor = DXColors.Light4,
			IconScale = 0.65f
		};
		
		layout.Add( iconBtn );
	}

	// Post construction initialization
	public override void Init()
	{
		base.Init();
		
		iconBtn.Init();	
	}
	
	// Hides child icon button
	protected override void SetVisible( bool visible )
	{
		base.SetVisible( visible );

		iconBtn.IsVisible = visible;
	}

	// Visually disables button
	protected override void SetDisabled( bool disabled )
	{
		base.SetDisabled( disabled );

		iconBtn.IsDisabled = disabled;
	}

	// Resets sticky to normal state
	public void Reset()
	{
		iconBtn.Reset();
	}

	// Removes UI components from parent view
	public override void Remove()
	{
		base.Remove();

		layout.Remove( iconBtn );
	}

	/* Layout */

	// Positions button in parent layout
	public override void Layout( double x, double y, double size )
	{
		base.Layout( x, y, size );

		// May not have title
		double adjY = y + (HasTitle ? (TitleHt + Spacing) : 0);
		
		layout.SetBounds( iconBtn, x, adjY, size, size );
		
		// Circle/square
		iconBtn.SetSize( size, IsCircle );
	}
}

//
