﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Layout;

namespace iStatVball3;

/*
 * Draws a simple divider line, either vertically or horizontally, in a recording UI drawer.
 */
public class DrawerDivider : BoxView
{
	/* Constants */
	public const double Thickness = 1;

	/* Fields */
	private readonly DXAbsoluteLayout layout;

	/* Methods */
	public DrawerDivider( DXAbsoluteLayout layout )
	{
		this.layout = layout;

		Color = DXColors.Dark3;
		CornerRadius = 0;

		layout.Add( this );
	}

	/* Layout */

	// Position divider line within parent layout
	public void Layout( double x, double y, double wd, double ht )
	{
		WidthRequest = wd;
		HeightRequest = ht;

		layout.SetBounds( this, x, y, wd, ht );
	}
}

//
