﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Layout;
using DXLib.UI.Control.Button;

using DXLib.Utils;

namespace iStatVball3;

/*
 * A numeric button with a text title used throughout recording UI drawers.
 */ 
public class DrawerButton : DrawerBase
{
	/* Events */
	public Action<DXButton> ButtonTapped { set => numberBtn.ButtonTapped = value; }
	public Action<DXButton> ButtonPressed { set => numberBtn.ButtonPressed = value; }

	/* Properties */
	public string Text { set => numberBtn.Text = value; }
	public int Number { set => numberBtn.Number = value; }
	
	// Button config
	public double NumberSize { set => numberBtn.NumberSize = value; }
	public double NumberAdjustY { set => numberBtn.TextAdjustY = value; }

	public Color NumberColor { set => numberBtn.NumberColor = value; }
	public Color Color { set => numberBtn.ButtonColor = value; }
	
	public bool HasShadow { set => numberBtn.HasShadow = value; }

	// Tap control
	public bool IsSticky { set => numberBtn.IsSticky = value; }

	// Used to anchor popups
	public View View => numberBtn;

	/* Fields */
	private readonly DXNumberButton numberBtn;

	/* Methods */
	public DrawerButton( DXAbsoluteLayout layout ) : base( layout )
	{
		bool ios = DXDevice.IsIOS;
		
		// Underlying button
		numberBtn = new DXNumberButton
		{
			NumberColor = DXColors.Light4,
			
			IsCircle = false,
			HasShadow = true,
			
			TextAdjustY = ios ? 0 : -6,
			
			Horizontal = LayoutOptions.Fill,
			Vertical = LayoutOptions.Fill
		};
		
		layout.Add( numberBtn );
	}

	// Post construction initialization
	public override void Init()
	{
		base.Init();
		
		numberBtn.Init();
	}

	// Hides child button
	protected override void SetVisible( bool visible )
	{
		base.SetVisible( visible );

		numberBtn.IsVisible = visible;
	}

	// Visually disables button
	protected override void SetDisabled( bool disabled )
	{
		base.SetDisabled( disabled );

		numberBtn.IsDisabled = disabled;
	}

	// Resets button sticky state
	public void Reset()
	{
		numberBtn.Reset();
	}

	// Removes UI components from parent view
	public override void Remove()
	{
		base.Remove();

		layout.Remove( numberBtn );
	}

	/* Layout */

	// Positions button in parent layout
	public override void Layout( double x, double y, double size )
	{
		base.Layout( x, y, size );

		numberBtn.Size = size;
		layout.SetBounds( numberBtn, x, (y + ChildY), size, size );
	}
}

//
