﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace iStatVball3;

/*
 * Interface used to route data between the underlying stat cache and recording UI components such as the MarkerStack.
 */
public interface RecordHandler
{
	/* Properties */
	public int StatCount { get; }

	/* Methods */

	// Returns stat at specified index in stack
	public Stat GetStat( int index );

	// Returns last stat of specified action type for given player
	public Stat PreviousStat( string action, Player player );

	// Returns last stat of specified action type for given rotation
	public Stat PreviousStat( string teamId, string action, int rotation );
}

//
