﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Gestures;

using DXLib.Utils;

namespace iStatVball3;

/*
 * A simple shell for RecordEngine so that the engine is abstracted from the drawing layout. This allows the engine to
 * be embedded into other areas of the UI.
 */
public class RecordForm : DXAbsoluteGestures
{
	/* Properties */
	public Set Set { get; private set; }
	public RecordState StateMachine => engine.StateMachine;

	/* Fields */
	private readonly RecordEngine engine;

	/* Methods */
	public RecordForm( bool legacy )
	{
		IsVisible = false;

		// MUST be full screen
		IgnoreSafeArea = true;
		
		Horizontal = LayoutOptions.Fill;
		Vertical = LayoutOptions.Fill;

		BackgroundColor = legacy ? DXColors.Dark1 : DXColors.Dark2;

		// Create Legacy or RallyFlow engine
		engine = legacy ? new LegacyEngine( this ) : new RallyEngine( this, RallyEngine.EngineMode.Record );
	}

	// Post construction initialization
	public async Task Init( Set set )
	{
		Set = set;

		await engine.Init( set );
	}

	// Starts engine recording (must be called each set)
	public async Task Start()
	{
		await engine.Start();
	}

	/* Layout */

	// Special handling on device rotation
	public override void Rotate()
	{
		engine.Rotate();
	}

	// Redraws all UI components based on device/orientation
	public override void UpdateLayout( LayoutType type )
	{
		double screenWd = DXDevice.GetScreenWd();
		double screenHt = DXDevice.GetScreenHt();
		
		engine.SetLayoutBounds( new Rect( 0, 0, screenWd, screenHt ) );
		engine.UpdateLayout( type );
	}
}

//
