﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace iStatVball3;

/*
 * Used to pass data from the stat recording interface to the state machine, and then from state machine to the database. 
 */
public class RecordData
{
	/* Properties */
	public bool Legacy { get; set; }

	public float X { get; set; }
	public float Y { get; set; }

	public Player Player { get; set; }
	public Player Player2 { get; set; }
	public Player Player3 { get; set; }

	public string Number { get; set; }
	public string Number2 { get; set; }
	public string Number3 { get; set; }

	public string Position { get; set; }
	public string Position2 { get; set; }
	public string Position3 { get; set; }

	public int CourtPosition { get; set; }
	public int CourtRow { get; set; }

	public string Action { get; set; }
	public string Selector { get; set; }
	public string Modifier { get; set; }

	public string Result { get; set; }
	public string Error { get; set; }
	public string Fault { get; set; }

	// Action coming from player/team error or fault?
	public bool IsError { get; set; }
	public bool IsTeamError { get; set; }
	public bool IsPrevTeamError { get; set; }
	public bool IsFault => (Error == Stats.FaultKey);

	public bool IsServe => (Action == Stats.ServeKey);
	public bool IsPoint => (Action == Stats.PointKey);

	// Player attributable action?
	public bool IsAnonymous => Player == null;

	// Backpatch fields (ratings can be globally turned on/off)
	public int? Rating { get; set; }
	public int? PrevRating { get; set; }

	public string PrevResult { get; set; }
	public string Prev2Result { get; set; }
	public string Prev3Result { get; set; }

	public string PrevError { get; set; }
	public string Prev2Error { get; set; }

	public int? PrevValue { get; set;}
	public int? Prev2Value { get; set; }
    public int? Prev3Value { get; set; }

    // Special handling for defense
    public bool PrevDefense { get; set; }
	public bool Touch { get; set; }

	// Rotation of team earning point and receiving (BEFORE sideout)
	public int Rotation { get; set; }
	public int RecvRotation { get; set; }

	// Sideout?
	public bool Sideout { get; set; }

	// Earned point?
	public bool Earned { get; set; }

	// Auto generated?
	public bool Auto { get; set; }

	// Lineup changes
	public List<LineupEntry> Entries_Pre { get; set; }
	public List<LineupEntry> Entries_Post { get; set; }

	// WHP profiling
	public float? WHP { get; set; }

	// Generic field for context specific flag/value
	public int Value { get; set; }

	// As close as possible to time of tap
	public DateTimeOffset? Timestamp { get; set; }

	/* FKs */

	// Player IDs
	public string PlayerId => Player?.UniqueId;
	public string Player2Id => Player2?.UniqueId;
	public string Player3Id => Player3?.UniqueId;

	// Receiving team
	public string ReceiveId { get; set; }

	// Team CAUSING point (error or earned)
	public string CausedId { get; set; }

	// Team actually AWARDED point
	public string TeamId { get; set; }
}

//
