﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace iStatVball3;

/*
 * Used to pass configuration information to the stat recording interface for the start of a new set. Includes fields
 * for both the RallyFlow and Legacy engines.
 */ 
public class RecordConfig
{
	/* Properties */
	public Set Set { get; set; }

	public Team Team1 { get; set; }
	public Team Team2 { get; set; }

	public RecordLineup Lineup1 { get; set; }
	public RecordLineup Lineup2 { get; set; }

	public int Rotation1 { get; set; }
	public int Rotation2 { get; set; }

	public Team ServeFirst { get; set; }
	public RecordCourt.Side ServeSide { get; set; }

	public int Points1 { get; set; }
	public int Points2 { get; set; }

	/* UI References */

	// Shared
	public RecordEngine Parent { get; set; }
	public RecordScore Scoreboard { get; set; }

	// RallyFlow
	public ActionOverlay Overlay { get; set; }
	public CourtView Court { get; set; }
	
	public TeamBar Teambar1 { get; set; }
	public TeamBar Teambar2 { get; set; }

	// Legacy
	public PlayerGrid PlayerGrid { get; set; }
}

//
