﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace iStatVball3;

/*
 * Encapsulates all parameters that must be passed from the recording UI to the WHP algorithm in order to calculate
 * scores for an individual action.
 */
public class WHPConfig
{
	/* Properties */

	public string TeamId { get; set; }

	public string Action { get; set; }
	public int Rotation { get; set; }
	public int Zone { get; set; }

	public float X { get; set; }
	public float Y { get; set; }

	public Stat Previous { get; set; }

	public bool UseML { get; set; }
	public bool LiberoLB { get; set; }

	public RallyState StateMachine { get; set; }

	/* Methods */

	// Determines if specified action matches action from this config
	public bool EqualsAction( string action )
	{
		// Irrelevant actions should be pre-filtered
		return Action switch
		{
			// Receive
			Stats.ReceiveKey => action.Equals( Stats.ReceiveKey ),
			
			// Second
			Stats.SecondKey => action.Equals( Stats.SecondKey ),
			
			// Third/Block/Over grouped
			Stats.ThirdKey or 
			Stats.BlockKey or 
			Stats.OverpassKey => action.Equals( Stats.ThirdKey ) || action.Equals( Stats.BlockKey ) || action.Equals( Stats.OverpassKey ),
			
			// All non-receive passing actions grouped
			Stats.DefenseKey or 
			Stats.FirstKey or 
			Stats.FreeballKey or 
			Stats.PutbackKey => action.Equals( Stats.DefenseKey ) || action.Equals( Stats.FirstKey ) ||
			                    action.Equals( Stats.FreeballKey ) || action.Equals( Stats.PutbackKey ),
			
			// Should not happen
			_ => false
		};
	}
}

//
