﻿/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

using DXLib.UI.Layout;
using DXLib.UI.Control.Button;

using DXLib.Utils;

namespace iStatVball3;

/*
 * A version of DXButton customized for use in a teambar drawer.
 */
public class TeamButton : DXButton
{
	/* Fields */
	private readonly DXAbsoluteLayout layout;

	/* Methods */
	public TeamButton( DXAbsoluteLayout layout )
	{
		this.layout = layout;

		FontSize = DXDevice.IsTablet ? 15 : 12;
		IsSticky = true;

		layout.Add( this );
	}

	/* Layout */

	// Positions button within parent layout
	public void Layout( double x, double y, double wd, double ht )
	{
		ButtonWd = wd;
		ButtonHt = ht;

		layout.SetBounds( this, x, y, wd, ht );
	}
}

//
