﻿/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

using SkiaSharp;

using DXLib.Utils;

namespace iStatVball3;

/*
 * Draws a directional arrow with arrowhead between two court markers.
 */ 
public class MarkerArrow
{
	/* Constants */

	// Default colors
	private static readonly SKColor LightColor = SKColor.Parse( "cccccc" );
	private static readonly SKColor DarkColor = SKColor.Parse( "aaaaaa" );

	// Arrow thickness/size relative to constant marker size
	private static readonly float Radius = (CourtView.MarkerSize / 2.0f);

	private static readonly float Weight = (Radius / 10.0f);
	private static readonly float Size = (Radius / 3.0f);

	private static readonly float Radius1 = (Radius * 1.1f);
	private static readonly float Radius2 = (Radius * 1.25f);

	// Do not draw really short arrows
	private static readonly float MinLen = Radius;

	/* Properties */
	public Marker From { get; set; }
	public Marker To { get; set; }

	// Color control
	public bool IsDark { get; set; }

	/* Methods */

	// Draw arrow using SkiaSharp
	public void Paint( SKCanvas canvas )
	{
		SKColor color = IsDark ? DarkColor : LightColor;

		DXGraphics.DrawArrow( canvas, From.Location, To.Location, color, Weight, Size, Radius1, Radius2, 0, MinLen );
	}
}

//
