﻿/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

using DXLib.UI;
using DXLib.UI.Control;
using DXLib.UI.Container;

namespace iStatVball3;

/*
 * Represents an individual button on an action menu flyout.
 */ 
public class FlyoutButton : DXContent
{
	/* Constants */
	private static readonly Color SelectedColor = DXColors.Light4;

	/* Properties */
	public int Index { get; set; }

	public string Key { get; set; }
	public string Text { set => textLbl.Text = value?.ToUpper()!; }

	public double TextSize { set => textLbl.FontSize = value; }

	// Inverted selection
	public bool IsSelected { get; private set; }

	/* Fields */
	private readonly DXLabel textLbl;

	/* Methods */
	public FlyoutButton()
	{
		IsClippedToBounds = true;

		// Underlying control
		textLbl = new DXLabel
		{
			Font = DXFonts.RobotoCondensedBold,

			Horizontal = LayoutOptions.Center,
			Vertical = LayoutOptions.Center
		};

		Content = textLbl;
	}

	// Post construction initialization
	public void Init()
	{
		Select( false );
	}

	// Visually marks this button as (de)selected
	public void Select( bool selected )
	{
		IsSelected = selected;

		// Invert colors
		BackgroundColor = selected ? SelectedColor : Color;
		textLbl.TextColor = selected ? Color : SelectedColor;
	}

	/* Event Handling */

	// Determines if specified point is on this button
	public bool Contains( Point origin, Point pt )
	{
		Rect bounds = Bounds.Offset( origin );

		return bounds.Contains( pt );
	}
}

//
