﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Layout;
using DXLib.UI.Control;
using DXLib.UI.Gestures;

namespace iStatVball3;

/*
 * A simple icon used to mark an invalid tap location on the court.
 */ 
public class ActionInvalid : DXGridLayout
{
	/* Fields */
	private readonly DXFill fill;
	private readonly DXIcon icon;
	
	private readonly DXAbsoluteGestures layout;

	/* Methods */
	public ActionInvalid( DXAbsoluteGestures layout )
	{
		this.layout = layout;

		IsVisible = false;

		Padding = 0;
		Margin = 0;

		RowSpacing = 0;
		ColumnSpacing = 0;
		
		// Solid background (fills 'X')
		fill = new DXFill
		{
			Color = DXColors.Light4
		};
		
		// 'X' icon
		icon = new DXIcon
		{
			Resource = "cancel",
			Color = DXColors.Dark1,
			Scale = 0.95f
		};
		
		Add( fill, 0, 0 );
		Add( icon, 0, 0 );
		
		// Add to parent layout
		layout.Add( this );
	}

	// Displays marker at specified location
	public void Show( double x, double y )
	{
		double markerSize = (CourtView.MarkerSize / CourtView.DpScale);
		double radius = (markerSize / 2.0);

		double size = (markerSize + 7);

		// Dynamic sizing
		fill.Circle = size;
		icon.Size = size;

		double centerX = Math.Floor( x - radius );
		double centerY = Math.Floor( y - radius );

		// Center at x,y
		layout.SetBounds( this, centerX, centerY, size, size );

		IsVisible = true;
	}

	// Removes marker from display
	public void Hide()
	{
		IsVisible = false;
	}
}

//
