﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace iStatVball3;

/*
 * A convenience container for passing all parameters necessary to configure an ActionMenu for a particular state in the
 * state machine. 
 */ 
public class ActionConfig
{
	/* Properties */

	// Showing menu for Team 1 or 2?
	public bool IsTeam1 { get; set; }

	// Action type
	public string Action { get; set; }
	public string PrevAction { get; set; }

	// Error handling
	public string Error { get; set; }
	public bool IsTeamError { get; set; }

	// Lookup key for each flyout
	public string Ratings { get; set; }
	public string Modifiers { get; set; }
	public string Modifiers2 { get; set; }
	public string Selectors { get; set; }

	// Default selection for each flyout
	public string Rating { get; set; }
	public string Modifier { get; set; }
	public string Modifier2 { get; set; }
	public string Selector { get; set; }

	// QuickSelect
	public bool Override { get; set; }
	public bool PrevSetter { get; set; }

	// Callback when action menu releases (normal/previous)
	public Action<RecordData> Selected { get; set; }

	// Using pass rating flyout?
	public bool IsPassRating => Ratings is Settings.Pass03Key or Settings.Pass04Key;
}

//
