/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

namespace iStatVball3;

/*
 * Container for Stat constants used throughout the app. 
 */
public abstract class Stats
{
	/* Constants */

	// Non-Action types
	public const string UpdateKey = "update";
	public const string LineupKey = "lineup";
	public const string PointKey = "point";

	// Actions
	public const string ServeKey = "serve";
	public const string ReceiveKey = "receive";
	public const string FirstKey = "first";
	public const string SecondKey = "second";
	public const string ThirdKey = "third";
	public const string DefenseKey = "defense";
	public const string PutbackKey = "putback";
	public const string FreeballKey = "freeball";
	public const string BlockKey = "block";
	public const string OverpassKey = "over";

	// Selectors
	public const string AttackKey = "attack";
	public const string Attack2Key = "attack2";
	public const string Attack3Key = "attack3";

	public const string SetKey = "set";
	public const string FreeKey = "free";
	public const string PassKey = "pass";

	// Selectors- Lineup
	public const string SwapInKey = "swapin";
	public const string SwapOutKey = "swapout";
	public const string SubKey = "sub";
	public const string ReplaceKey = "replace";

	// Selectors- Update
	public const string SwitchKey = "switch";
	public const string PossessionKey = "poss";
	public const string ScoreKey = "score";
	public const string TimeoutKey = "timeout";
	public const string RotationKey = "rotation";
	public const string ForcedKey = "forced";
	public const string EndKey = "end";

	// Results
	public const string AttemptKey = "att";
	public const string ErrorKey = "err";
	public const string FaultKey = "fault";

	public const string TeamKey = "team";
	public const string PrevKey = "prev";
	public const string DoubleKey = "double";
	public const string DownKey = "down";

	public const string TREKey = "tre";
	public const string BHEKey = "bhe";

	public const string AceKey = "ace";
	public const string AssistKey = "assist";
	public const string KillKey = "kill";
	public const string PreBlockKey = "preBlock";
	public const string BlockAssistKey = "blockAssist";		
	public const string BlockAssistsKey = "blockAssists";
	public const string DigKey = "dig";

	// Errors
	public const string NetKey = "net";
	public const string OutKey = "out";
	public const string AntKey = "ant";
	public const string FourKey = "four";

	// Ratings
	public const string Rating0 = "0";
	public const string Rating1 = "1";
	public const string Rating2 = "2";
	public const string Rating3 = "3";
	public const string Rating4 = "4";

	// Special action (includes first, putback, freeball)
	public const string PassingKey = "passing";

	// Used to indicate end x/y for faults (same as start)
	public const float FaultX = -1.0f;
	public const float FaultY = -1.0f;
}

//
