﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using Plugin.Firebase.Firestore;

namespace iStatVball3;

/*
 * Encapsulates fields used to store video sync settings for a set. Persisted as a map in the parent Set NOT as a
 * top-level collection.
 */
public class SetVideo : IFirestoreObject
{
	/* Constants */
	public const int OffsetUnknown = 0;

	/* Properties */

	// Time offset of first serve (ms)
	[FirestoreProperty( "Offset" )] public int Offset { get; set; }

	/* Methods */
	public SetVideo()
	{
		// Defaults
		Offset = OffsetUnknown;
	}
}

//
