﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Layout;
using DXLib.UI.Control;

namespace iStatVball3;

/*
 * SfTreeView view template for root linking Team level.
 */
public class RootTemplateTeam : DXGridLayout
{
	/* Methods */
	public RootTemplateTeam()
	{
		BackgroundColor = DXColors.Light4;
		Padding = new Thickness( 10, 0 );

		// Team name
		DXLabel nameLbl = new DXLabel
		{
			TextColor = DXColors.Dark1,
			FontResource = DXFonts.RobotoBold,
			FontSize = 18,

			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Center
		};

		nameLbl.SetBinding( Label.TextProperty, new Binding( "Content.Name" ) );

		Add( nameLbl, 0, 0 );
	}
}

//
