﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Layout;
using DXLib.UI.Control;

namespace iStatVball3;

/*
 * SfTreeView view template for Seasons beneath root Team level.
 */
public class RootTemplateSeason : DXGridLayout
{
	/* Methods */
	public RootTemplateSeason()
	{
		BackgroundColor = DXColors.Light4;
		Padding = new Thickness( 10, 0 );

		// Category name
		DXLabel nameLbl = new()
		{
			TextColor = DXColors.Dark1,
			Font = DXFonts.RobotoBold,
			FontSize = 17,

			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Center
		};

		nameLbl.SetBinding( Label.TextProperty, new Binding( "Content.Name" ) );

		Add( nameLbl, 0, 0 );
	}
}

//
