﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Layout;

using DXLib.UI.Control;
using DXLib.UI.Control.Badge;

namespace iStatVball3;

/*
 * SfTreeView view template for leaf level Players within parent Season.
 */
public class RootTemplatePlayer : DXGridLayout
{
	/* Methods */
	public RootTemplatePlayer()
	{
		Padding = new Thickness( 5, 0 );
		RowSpacing = 0;
		ColumnSpacing = 10;

		const double badgeSize = 24;

		// 3 columns
		AddFixedColumn( badgeSize );    // 0: number
		AddStarColumn();                // 1: name

		// Number
		DXNumberBadge numberBadge = new DXNumberBadge
		{
			Size = badgeSize,
			FontSize = 14,

			Color = DXColors.Action,
			TextColor = DXColors.Light4,

			AdjustY = -1,
			
			Horizontal = LayoutOptions.End,
			Vertical = LayoutOptions.Center
		};

		numberBadge.Init();
		numberBadge.SetBinding( DXNumberBadge.TextProperty, new Binding( "Content.Number" ) );

		Add( numberBadge, 0, 0 );

		// Name
		DXLabel nameLbl = new DXLabel
		{
			TextColor = DXColors.Dark1,
			Font = DXFonts.Roboto,
			FontSize = 15,

			LineBreakMode = LineBreakMode.TailTruncation,

			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Center
		};

		nameLbl.SetBinding( Label.TextProperty, new Binding( "Content.Name" ) );

		Add( nameLbl, 1, 0 );
	}
}

//
