﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using Syncfusion.TreeView.Engine;

namespace iStatVball3;

/*
 * DataTemplateSelector for SfTreeView returning custom templates for each level (team, season, player) of the
 * hierarchical root selector tree.
 */
public class RootTreeSelector : DataTemplateSelector
{
    /* Fields */
    private readonly DataTemplate team;
    private readonly DataTemplate season;
    private readonly DataTemplate player;

    /* Methods */
    public RootTreeSelector()
    {
        team = new DataTemplate( typeof( RootTemplateTeam ) );
        season = new DataTemplate( typeof( RootTemplateSeason ) );
        player = new DataTemplate( typeof( RootTemplatePlayer ) );
    }

    // Returns template based on tree level
    protected override DataTemplate OnSelectTemplate( object item, BindableObject container )
    {
        if ( item is not TreeViewNode node )
        {
            return null;
        }

        // Team
        if ( node.Level == 0 )
        {
            return team;
        }

        // Season or player
        return node.HasChildNodes ? season : player;
    }
}

//
