﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using System.Collections.ObjectModel;

namespace iStatVball3;

/*
 * Data object associated with each node of a RootTree. Encapsulates all data required for Team, Season, and Player nodes.
 */
public class RootTreeData
{
	/* Properties */
	public Season Season { get; set; }
	public object Object { get; set; }

	public string Name { get; set; }
	public string Number { get; set; }

	// Hierarchical nodes
	public ObservableCollection<RootTreeData> SubData { get; set; }

	// Reference to parent SfTreeView
	public RootTree Tree { get; set; }
}

//
