﻿/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

using Plugin.Firebase.Firestore;

using DXLib.Data.Model;

namespace iStatVball3;

/*
 * Represents a Consumable In-App Purchase for one or more Team-Seasons. Persisted as an array of maps within the
 * corresponding user, NOT as a root level collection.
 */
public class Purchase : DXModel
{
	/* Constants */

	// Used to indicate free trial state
	public const string FreeTrialId = "istatvball3_freetrial";

	// Product identifiers
	public const string TeamSeasons1Id = "istatvball3_teamseason_01";
	public const string TeamSeasons2Id = "istatvball3_teamseason_02";
	public const string TeamSeasons3Id = "istatvball3_teamseason_03";
	public const string TeamSeasons4Id = "istatvball3_teamseason_04";

	public const string TeamSeasonsAdminId = "<admin>";

	/* Properties */
	[FirestoreProperty("ProductId")] public string ProductId { get; set; }
	[FirestoreProperty("PurchaseId")] public string PurchaseId { get; set; }
	[FirestoreProperty("Platform")] public string Platform { get; set; }

	// Number Team-Seasons purchased
	[FirestoreProperty("Count")] public int Count { get; set; }

	// Number of purchased that have been allocated
	[FirestoreProperty("Used")] public int Used { get; set; }

	/* Ignored */
	public int Remaining => (Count - Used);

	/* Methods */

	// Tests equality based on unique identifier
	public override bool Equals( object obj )
	{
		return (obj is Purchase purchase) && purchase.UniqueId.Equals( UniqueId );
	}

	// Generates unique hash code (required)
	public override int GetHashCode()
	{
		return UniqueId.GetHashCode();
	}

	// Returns Team-Season count for specified product ID
	public static int GetCount( string productId )
	{
		return productId switch
		{
			TeamSeasons1Id => 1,
			TeamSeasons2Id => 2,
			TeamSeasons3Id => 3,
			TeamSeasons4Id => 4,

			_ => 0,
		};
	}
}

//
