﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Control.Badge;

using DXLib.Utils;

namespace iStatVball3;

/*
 * Custom small card used to add alternate jersey number badge for players.
 */ 
public class PlayerCard : CardSmall
{
	/* Properties */
	public string AltNumber { set => AddAltNumber( value ); }

	/* Fields */
	private DXNumberBadge altBadge;

	/* Methods */
	public PlayerCard( Player player )
	{
		Data = player;
	}

	// Adds alternate jersey number badge
	private void AddAltNumber( string value )
	{
		// Alternate number
		if ( string.IsNullOrEmpty( value ) )
		{
			if ( altBadge != null )
			{
				layout.Remove( altBadge );
			}

			altBadge = null;
		}
		else
		{
			if ( Data is Player player )
			{
				// Deactivated players are faded
				double opacity = player.IsDeactivated ? DeactivatedOpacity : 1.0;

				// Lazy creation
				altBadge = new DXNumberBadge
				{
					Text = value,
					AdjustY = -1,
					Opacity = opacity,

					Size = 36,
					FontSize = 18,

					Color = DXColors.Dark4,
					TextColor = DXColors.Light4,

					Padding = new Thickness( 56, 10, 0, 0 ),
					Margin = 0,
					
					Horizontal = LayoutOptions.Start
				};

				altBadge.Init();

				layout.Add( altBadge, 0, 1 );
			}
		}
	}

	// Returns custom text for root link tooltip
	protected override async Task<string> GetRootText()
	{
		if ( Data is Player player )
		{
			Root root = player.Root;

			Organization org = player.Season.Team.Organization;

			// Check that player not deleted
			if ( await root.IsValid( org ) )
			{
				Player rootPlayer = root.Player;

				// 'Varsity 2019'
				string teamSeason = $"{root.Team.Name} {root.Season.Name}";

				// 'linked to <Name> #<Number> from <TeamSeason>'
				return DXString.Get( "root.link.tip", rootPlayer.FullName, rootPlayer.Number, teamSeason );
			}
		}

		return null;
	}
}

//
