﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

namespace iStatVball3;

/*
 * Convenience container used for grouping identifiers necessary to access a user permission.
 */
public class PermissionKeys
{
	/* Properties */

	// Permission level (Coach, Player, etc)
	public Permission.LevelType Level { get; init; }

	// Associated team
	public Team Team { get; set; }

	// Flattened FKs
	public string TeamId { get; init; }
	public string OrganizationId { get; init; }

	// Unique identifier of associated object (team, coach, etc)
	public string EntityId { get; init; }
}

//
