﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Container;
using DXLib.UI.Control.Button;

using DXLib.Utils;

namespace iStatVball3;

/*
 * Custom card for Organizations that adds an icon for MaxPreps links.
 */
public class OrganizationCard : CardLarge
{
    /* Fields */
    private readonly DXIconButton maxPrepsBtn;

    /* Methods */
    public OrganizationCard( Organization org, bool readOnly ) : base( readOnly )
    {
        // Add link icon
        if ( org.HasMaxPreps )
        {
            maxPrepsBtn = new DXIconButton
            {
                Resource = "maxpreps",

                Size = IconSize,
                Margin = IconPad,

                IconColor = DXColors.Negative,

                IsSticky = true,
                IsVisible = true,

                Horizontal = LayoutOptions.End,
                Vertical = LayoutOptions.End,

                ButtonTapped = OnMaxPrepsTapped
            };

            layout.Add( maxPrepsBtn, 2, 2 );
        }
    }
    
    // Used to exclude buttons from card tap area
    protected override bool IsChildBounds( Point point )
    {
        return base.IsChildBounds( point ) || ((maxPrepsBtn != null) && maxPrepsBtn.Contains( point ));
    }

    /* Event Callbacks */

    // User tapped link icon
    private void OnMaxPrepsTapped()
    {
        if ( Data is Organization org )
        {
            // Same view as selector list
            MP2SchoolView view = new( org.MaxPreps );

            // Show linked school in popup
            DXPopup popup = new( DXString.Get( "maxpreps2.title" ), view )
            {
                ViewWidth = MP2SchoolView.ViewWd,
                ViewHeight = MP2SchoolView.ViewHt,

                PopupClosed = maxPrepsBtn.Reset
            };

            popup.ShowFromView( maxPrepsBtn );
        }
    }
}

//
