﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Container;
using DXLib.UI.Control.Button;

namespace iStatVball3;

/*
 * Custom card for Opponents that adds an icon for MaxPreps links.
 */
public class OpponentCard : CardSmall
{
    /* Fields */
    private readonly DXIconButton maxPrepsBtn;

    /* Methods */
    public OpponentCard( Opponent opponent, bool readOnly ) : base( true, readOnly )
    {
        // Add link icon
        if ( opponent.HasMaxPreps )
        {
            maxPrepsBtn = new DXIconButton
            {
                Resource = "maxpreps",

                Size = IconSize,
                Margin = IconPad,

                IconColor = DXColors.Negative,

                IsSticky = true,
                IsVisible = true,

                Horizontal = LayoutOptions.End,
                Vertical = LayoutOptions.End,

                ButtonTapped = OnMaxPrepsTapped
            };

            layout.Add( maxPrepsBtn, 2, 2 );
        }
    }

    /* Event Callbacks */

    // User tapped link icon
    private void OnMaxPrepsTapped()
    {
        if ( Data is Opponent opponent )
        {
            // Same view as selector list
            MP2SchoolView view = new( opponent.MaxPreps );

            // Show linked school in popup
            DXPopup popup = new( "maxpreps2.title", view )
            {
                ViewWidth = MP2SchoolView.ViewWd,
                ViewHeight = MP2SchoolView.ViewHt,

                PopupClosed = maxPrepsBtn.Reset
            };

            popup.ShowFromView( maxPrepsBtn );
        }
    }
}

//
