﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using Plugin.Firebase.Firestore;

namespace iStatVball3;

/*
 * Encapsulates fields used to store video sync settings for a match. Persisted as a map in the parent Match NOT as a
 * top-level collection.
 */
public class MatchVideo : IFirestoreObject
{
	/* Properties */

	// Video synced to stats?
	[FirestoreProperty("Sync")] public bool Sync { get; set; }

	// YouTube, Vimeo, etc.
	[FirestoreProperty("Host")] public string Host { get; set; }
	
	// Platform specific video File ID
	[FirestoreProperty("FileId")] public string FileId { get; set; }

	// Allow sharing with players/fans?
	[FirestoreProperty("Share")] public bool Share { get; set; }

	/* Methods */
	public MatchVideo()
	{
		// Defaults
		Sync = false;
		Host = null;
		FileId = null;
		Share = false;
	}
	
	/* Permissions */

	// Determines if specified user has permission to use sync tool
	public static bool CanSync( User user )
	{
		return user.Level switch
		{
			// Only Director/Coach have access
			User.LevelType.Director or 
			User.LevelType.Coach => true,
			
			_ => false
		};
	}

	// Determines if specified user has permission to use video tool for this video
	public bool CanView( User user )
	{
		return user.Level switch
		{
			// Director/Coach always
			User.LevelType.Director or
			User.LevelType.Coach => true,
			
			// Media never
			User.LevelType.Media or 
			User.LevelType.None => false,
				
			// Everyone else only if shared
			_ => Share
		};
	}
}

//
