﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.Data.Model;

namespace iStatVball3;

/*
 * Base model for all entities that use permission links. Provides common link CRUD functionality.
 */
public abstract class LinkModel : DXImageModel
{
	/* Update */

	// Updates status for specified link from list
	public abstract Task UpdateLink( string username, Link.StatusType status );

	// Used internally to update link status
	protected async Task UpdateLink( Link link, string username, Link.StatusType status, string field )
	{
		if ( (link != null) && link.Username.Equals( username ) )
		{
			link.Status = status;

			await Update( field, link );
		}
	}

	// Used internally to update status of link from list
	protected async Task UpdateLinks( IList<Link> links, string username, Link.StatusType status, string field )
	{
		Link link = Link.GetLink( links, username );

		// Persist new status
		await UpdateLink( link, username, status, field );
	}

	/* Delete */

	// Deletes link for specified user
	public virtual Task DeleteLink( string username )
	{
		return Task.CompletedTask;
	}

	// Deletes link from list of links for specificied user
	public virtual Task DeleteLinks( string username )
	{
		return Task.CompletedTask;
	}

	// Used internally to delete link for specified user
	protected async Task DeleteLink( Link link, string username, string field )
	{
		// Delete map from array
		if ( link.Username.Equals( username ) )
		{
			await DeleteElement( field, link );
		}
	}

	// Used internally to delete link from list of links for specified user
	protected async Task DeleteLinks( IList<Link> links, string username, string field )
	{
		// Remove all occurrences
		foreach ( Link link in links.ToList().Where( link => link.Username.Equals( username ) ) )
		{
			await DeleteElement( field, link );

			links.Remove( link );
		}

		await Update( field, links );
	}
}

//
