﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Gestures;

using DXLib.UI.Control;
using DXLib.UI.Control.List;

using DXLib.Utils;

namespace iStatVball3;

/*
 * Displays the 'Clear' footer row in a lineup player selection popup menu. This row is used to remove a current player
 * selection.
 */
public class LineupMenuFooter : DXContentGestures
{
	/* Constants */
	private readonly Color DefaultColor = DXColors.Dark1;
	private readonly Color TapColor = DXColors.Dark3;

	/* Events */
	public Action<Player> Selected { get; set; }

	/* Properties */
	public bool HasClear { set { IsEnabled = value; clearLbl.IsVisible = value; } }

	/* Fields */
	private readonly DXLabel clearLbl;

	/* Methods */
	public LineupMenuFooter()
	{
		BackgroundColor = DefaultColor;
		
		Padding = 0;

		Horizontal = LayoutOptions.Fill;
		Vertical = LayoutOptions.Fill;
		
		// Label
		clearLbl = new DXLabel
		{
			IsVisible = false,

			Text = DXString.GetUpper( "lineup.clear" ),
			TextColor = DXColors.Negative,
			
			Font = DXFonts.RobotoBoldItalic,
			FontSize = DXDevice.IsTablet ? 20 : 15,

			Margin = 0,

			Horizontal = LayoutOptions.Center,
			Vertical = LayoutOptions.Center
		};

		Content = clearLbl;

		// Register for events
		Tapped += OnTapped;
	}

	/* Event Callbacks */

	// User completed tap anywhere within row
	private void OnTapped( object sender, MR.Gestures.TapEventArgs args )
	{
		// Indicate tap with color change
		BackgroundColor = TapColor;

		// Return to normal after brief delay
		DXTimer.Delay( DXListMenu.TapDelay, () =>
		{
			BackgroundColor = DefaultColor;

			// Callback listener
			Selected?.Invoke( null );
		});
	}
}

//
