﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.Utils;

namespace iStatVball3;

/*
 * Custom card representing an individual lineup on a LineupPage.
 */ 
public sealed class LineupCard : CardSmall
{
	private readonly CardGrid imageGrid;

	/* Methods */
	public LineupCard( Season season )
	{
		// Image are used when no players for grid
		DefaultIcon = "lineup";
		ImageColor = season.Color;

		// Underlying grid control
		imageGrid = new CardGrid
		{
			Type = CardGrid.GridType.Lineup,

			DefaultIcon = "player",
			BorderSize = 2,

			IconColor = DXColors.Light4,
			ImageColor = season.Color,
			BorderColor = DXColors.Light4
		};

		imageGrid.Init();

		// On top of imageArea
		layout.Add( imageGrid, 2, 0, 1, 2 );
	}

	// Sets images (via players) for underlying image grid
	public void SetPlayers( List<Player> players )
	{
		imageGrid.SetPlayers( players );
	}

	/* Layout */

	// Device/orientation specific layout
	public override void UpdateLayout( LayoutType type )
	{
		base.UpdateLayout( type );

		Size size = GetImageSize();
		
		// Must (re)layout image grid
		imageGrid.SetSize( size, 0.8 );
		imageGrid.UpdateLayout( type );
	}
}

//
