﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using System.Text.Json.Serialization;
using Plugin.Firebase.Firestore;

using DXLib.Data.Model;
using DXLib.Utils;

namespace iStatVball3;

/*
 * Data model for persisting a custom analysis report. Persisted within the parent CustomDashboard, NOT as a root level
 * collection.
 */
public class CustomReport : DXModel
{
	/* Constants */
	private const string DimensionNA = "--";

	/* Properties */
	[FirestoreProperty("Category")] public string Category { get; set; }
	[FirestoreProperty("Dimension")] public string Dimension { get; set; }
	[FirestoreProperty("Type")] public string Type { get; set; }
	[FirestoreProperty("Stat")] public string Stat { get; set; }

	[FirestoreProperty("IsOnCard")] public bool IsOnCard { get; set; }

	/* Ignored */
	[JsonIgnore] public string Icon => Type;
	[JsonIgnore] public string StatLabel => GetStatLabel();
	[JsonIgnore] public string DimensionLabel => GetDimensionLabel();

	/* Methods */
	public CustomReport()
	{}

	// Tests equality based on unique identifier
	public override bool Equals( object obj )
	{
		return (obj is CustomReport report) && report.UniqueId.Equals( UniqueId );
	}

	// Generates unique hash code, required for list de-duping
	public override int GetHashCode()
	{
		return UniqueId.GetHashCode();
	}

	// Returns display label for statistic shown on this report
	private string GetStatLabel()
	{
		return DashboardCache.Instance.GetReport( this )?.Title;
	}

	// Returns display label for report dimension
	private string GetDimensionLabel()
	{
		// May not have dimension
		if ( string.IsNullOrEmpty( Dimension ) )
        {
			return DimensionNA;
        }

        Dictionary<string,string> table = DXString.GetLookupTable( "custom.dimension" );

		// Should always be in LUT
        return table.GetValueOrDefault( Dimension );
	}
}

//
