﻿/*
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC.
 */

using Syncfusion.Maui.ListView;

using DXLib.UI;
using DXLib.UI.Control.List;

namespace iStatVball3;

/*
 * Extends DXListView to add functionality specific to the play-by-play event log.
 */
public class LogListView : DXListView
{
	/* Events */
	public Action<object> EventSelected { set => ItemSelected = value; }

	/* Properties */
	public object EventSource { get => ItemsSource; set => ItemsSource = value; }

	/* Fields */
	private LogView.LogMode logMode;

	/* Methods */
	public LogListView()
	{
		RowHeight = 30;
		BackgroundColor = DXColors.Dark2;
	}

	// Post construction initialization
	public void Init( LogView.LogMode mode )
	{
		logMode = mode;

		// Selection mode
		Mode = (mode == LogView.LogMode.Live) ? SelectMode.None : SelectMode.Single;

		// Normal/select data templates
		ItemTemplate = new DataTemplate( () => new LogEventTemplate( mode ) );
		SelectedItemTemplate = new DataTemplate( () => new LogEventTemplate( mode, true ) );
	}

	/* Event Callbacks */

	// Item about to be selected (can disable selection here)
	protected override void OnSelectionChanging( object sender, ItemSelectionChangingEventArgs args )
	{
		if ( args.AddedItems?.Count > 0 )
		{
			// Can restrict selection to action stats
			if ( args.AddedItems[0] is LogEvent evt )
			{
				args.Cancel = !evt.Stat.IsAction && (logMode != LogView.LogMode.SelectAll);
			}
		}
	}
}

//
