﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Layout;
using DXLib.UI.Control;

using DXLib.Utils;

namespace iStatVball3;

/*
 * DataTemplate specifying layout for an individual event row in LogView.
 */
public class LogEventTemplate : DXGridLayout
{
	/* Constants */
	private const double MarkerSize = 10;

	/* Methods */
	public LogEventTemplate( LogView.LogMode mode, bool selected = false )
	{
		bool tablet = DXDevice.IsTablet;

		RowSpacing = 0;
		ColumnSpacing = 0;

		// Required for taps to register on Android
		InputTransparent = DXDevice.IsAndroid;

		// Row options
		this.SetBinding( PaddingProperty, "Padding" );
		this.SetBinding( BackgroundColorProperty, "Color" );
		this.SetBinding( OpacityProperty, "Opacity" );

		bool hasMarker = (mode == LogView.LogMode.Edit);

		DXFill marker = null;

		// Modification indicator
		if ( hasMarker )
		{
			marker = new DXFill
			{
				IsVisible = false,

				Circle = MarkerSize,
				Color = DXColors.Warn,

				Margin = DXUtils.Left( -1 ),

				Horizontal = LayoutOptions.Center,
				Vertical = LayoutOptions.Center
			};

			marker.SetBinding( IsVisibleProperty, "Modified" );
		}

		// Offset
		DXLabel offsetLbl = new()
		{
			Padding = 0,
			TextColor = DXColors.Light4,

			FontResource = DXFonts.Roboto,
			FontSize = 15,

			Margin = DXUtils.Left( 5 ),

			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Center
		};

		offsetLbl.SetBinding( Label.TextProperty, "Offset" );
		offsetLbl.SetBinding( Label.FontFamilyProperty, "Font" );
		offsetLbl.SetBinding( Label.FontSizeProperty, "FontSize" );

		// NA for select template
		if ( !selected )
		{
			offsetLbl.SetBinding( Label.TextColorProperty, "TextColor" );
		}

		// Log line
		DXLabel lineLbl = new()
		{
			Padding = 0,
			TextColor = DXColors.Light4,

			FontResource = DXFonts.Roboto,
			FontSize = 15,

			LineBreakMode = LineBreakMode.TailTruncation,

			Horizontal = LayoutOptions.Start,
			Vertical = LayoutOptions.Center
		};

		lineLbl.SetBinding( Label.TextProperty, "Line" );
		lineLbl.SetBinding( Label.FontFamilyProperty, "Font" );
		lineLbl.SetBinding( Label.FontSizeProperty, "FontSize" );

		// NA for select template
		if ( !selected )
		{
			lineLbl.SetBinding( Label.TextColorProperty, "TextColor" );
		}

		// Edit mode has modification marker
		if ( hasMarker )
		{
			AddFixedColumn( MarkerSize * 2 );

			if ( !selected )
			{
				Add( marker, 0, 0 );
			}
		}

		// 2 normal columns
		AddFixedColumn( tablet ? 60 : 55 );		// 1: offset
		AddStarColumn();						// 2: event

		// Select template has constant background color
		if ( selected )
		{
			Fill( DXColors.Action, 0, 0, (hasMarker ? 3 : 2), 1 );
		}

		// Add components
		Add( offsetLbl, (hasMarker ? 1 : 0), 0 );
		Add( lineLbl, (hasMarker ? 2 : 1), 0 );
	}
}

//
