﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using System.ComponentModel;

namespace iStatVball3;

/*
 * Represents a data element corresponding to an individual row in a LogView. All visual fields support MvvM style
 * property change notifications.
 */
public class LogEvent : INotifyPropertyChanged
{
	/* Events */
    public event PropertyChangedEventHandler PropertyChanged;

	/* Properties */

	// Underlying stat
	public Stat Stat { get; set; }

	// Event time offset
	public string Offset
	{
		get => offset;
		set { offset = value; OnPropertyChanged( "Offset" ); }
	}

	// Log line
	public string Line
	{
		get => line;
		set { line = value; OnPropertyChanged( "Line" ); }
	}

	// Event has changes?
	public bool Modified
	{
		get => modified;
		set { modified = value; OnPropertyChanged( "Modified" ); }
	}

	/* Styling */

	// Padding
	public Thickness Padding
	{
		get => padding;
		set { padding = value; OnPropertyChanged( "Padding" ); }
	}

	// Background color
	public Color Color
	{
		get => color;
		set { color = value; OnPropertyChanged( "Color" ); }
	}

	// Opacity
	public double Opacity
	{
		get => opacity;
		set { opacity = value; OnPropertyChanged( "Opacity" ); }
	}

	// Text color
	public Color TextColor
	{
		get => textColor;
		set { textColor = value; OnPropertyChanged( "TextColor" ); }
	}

	// Text font family
	public string Font
	{
		get => font;
		set { font = value; OnPropertyChanged( "Font" ); }
	}

	// Text font size
	public double FontSize
	{
		get => fontSize;
		set { fontSize = value; OnPropertyChanged( "FontSize" ); }
	}

	/* Fields */
	private string offset;
	private string line;

	private bool modified;

	// Styling
	private Thickness padding;
	private double opacity;

	private Color color;
	private Color textColor;

	private string font;
	private double fontSize;

	/* Methods */

	// Tests equality based on underlying unique identifier
	public override bool Equals( object obj )
	{
		return (obj is LogEvent evt) && evt.Stat.UniqueId.Equals( Stat.UniqueId );
	}

	// Generates unique hash code, required for list de-duping
	public override int GetHashCode()
	{
		return Stat.UniqueId.GetHashCode();
	}

	/* Event Callbacks */

	// Call property changed handler for specified property
	public void OnPropertyChanged( string name )
    {
		PropertyChanged?.Invoke( this, new PropertyChangedEventArgs( name ) );
	}
}

//
