﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI;
using DXLib.UI.Container;

using DXLib.Utils;

namespace iStatVball3;

/*
 * Slide out drawer used to display a Play-by-Play event log within the recording interface.
 */
public class LogDrawer : ToolBarDrawer
{
	/* Events */
	public Action<object> EventSelected { get; set; }

	/* Fields */
	private readonly LogView logView;

	/* Methods */
	public LogDrawer( DXDrawer drawer) : base( drawer )
	{
		bool tablet = DXDevice.IsTablet;

		BackgroundColor = DXColors.Dark2;

		Padding = tablet ? 15 : 10;
		RowSpacing = 0;
		ColumnSpacing = 0;

		// Create underlying control
		logView = new LogView( true )
		{
			Mode = LogView.LogMode.Select,
			FontSize = 16,

			EventSelected = OnEventSelected
		};

		Add( logView, 0, 0 );
	}

	// Post construction initialization
	public void Init( Set set )
	{
		logView.Init( set.Match );
	}

	// Loads all stats to be displayed in log
	public void Load( List<Stat> stats )
	{
		logView.Load( stats, true );
	}

	// Modifies specified stat in underlying log list
	public void Modify( Stat stat )
	{
		logView.Modify( stat );
	}

	// Removes specified stat from underlying log list
	public void Remove( Stat stat )
	{
		logView.Remove( stat );
	}

	// Redraws all events in log list
	public void Refresh()
	{
		logView.Refresh();
	}

	// Redraws specified event in log list
	public void Refresh( LogEvent evt )
	{
		logView.Refresh( evt );
	}

	// Returns event following specified event in log list
	public LogEvent GetNextEvent( LogEvent evt )
	{
		return logView.GetNextEvent( evt );
	}

	// Removes current selection in underlying log list
	public void Deselect()
	{
		logView.Deselect();
	}

	/* Event Callbacks */

	// User selected event from log list
	private void OnEventSelected( object data )
	{
		EventSelected?.Invoke( data );
	}
}

//
