﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using DXLib.UI.Form.Control;

namespace iStatVball3;

/*
 * Provides convenience functionality for a filter query dimension (team, action, etc). 
 */
public class FilterDimension
{
	/* Properties */
	public List<string> Keys => tree.SelectedKeys;

	// All/none keys currently selected?
	public bool NoneSelected => tree.NoneSelected;
	public bool AllSelected => tree.AllSelected;

	// Dimension currently disabled?
	public bool IsDisabled { get; private set; }

	/* Fields */
	readonly DXTreeSelect tree;

	/* Methods */
	public FilterDimension( DXTreeSelect tree, bool disabled = false )
	{
		this.tree = tree;

		IsDisabled = disabled;
	}

	// Determines if specified key included in current filter selection
	public bool Contains( string key )
	{
		// Include if all filter items selected or key present in filter list
		return AllSelected || ((key != null) && (Keys != null) && Keys.Contains( key ));
	}

	// Determines if specified numeric key included in filter selection
	public bool Contains( int key )
	{
		return Contains( key.ToString() );
	}
}

//
