﻿/* 
 * Copyright (c)2009-2025 DemiVision, LLC. All Rights Reserved. The information 
 * herein is the CONFIDENTIAL and PROPRIETARY information of DemiVision, LLC. 
 */

using System.Text;
using Plugin.Firebase.Firestore;

namespace iStatVball3;

/*
 * Represents a MaxPreps school used for both interface display and data persistence.
 */
public class MP2School : IFirestoreObject
{
	/* Constants */
    private const char Space = ' ';
    private const char Comma = ',';

    /* Properties */
    [FirestoreProperty("SchoolId")] public string SchoolId { get; set; }

    [FirestoreProperty("FormattedName")] public string FormattedName { get; set; }
    [FirestoreProperty("Name")] public string Name { get; set; }

    [FirestoreProperty("Mascot")] public string Mascot { get; set; }

    [FirestoreProperty("Address")] public string Address { get; set; }
    [FirestoreProperty("Address2")] public string Address2 { get; set; }

    [FirestoreProperty("City")] public string City { get; set; }
    [FirestoreProperty("State")] public string State { get; set; }
    [FirestoreProperty("Zip")] public string Zip { get; set; }

	/* Ignored */
	public string FullAddress => GetFullAddress();

	/* Methods */

	// Generates complete address in format '1234 Somewhere St. Springfield, IL 98765'
	private string GetFullAddress()
	{
		StringBuilder builder = new( Address );

		if ( !string.IsNullOrEmpty( Address ) )
		{
			builder.Append( Address );
		}

		if ( !string.IsNullOrEmpty( Address2 ) )
		{
			builder.Append( Space ).Append( Address2 );
		}

		if ( !string.IsNullOrEmpty( City ) )
        {
			builder.Append( Space ).Append( City );
        }

		if ( !string.IsNullOrEmpty( State ) )
		{
			builder.Append( Comma ).Append( Space ).Append( State );
		}

		if ( !string.IsNullOrEmpty( Zip ) )
		{
			builder.Append( Space ).Append( Zip );
		}

		return builder.ToString();
	}
}

//
